/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWSubmapUsageDialog;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWMapTableCellRenderer;
import filenet.vw.toolkit.design.property.tables.VWMapTableModel;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWTableActionListener;
import filenet.vw.toolkit.utils.event.VWTableActionEvent;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

class VWMapPanel
extends JPanel
implements IVWMapChangedListener,
IVWToolbarBorderActionListener,
TableModelListener,
ListSelectionListener,
IVWTableActionListener {
    private VWAuthPropertyData m_authPropertyData = null;
    private VWToolbarBorder m_mapNamesToolbar = null;
    private VWTable m_mapTable = null;
    private VWMapTableModel m_mapTableModel = null;

    public void mapChanged(VWMapChangedEvent event) {
        switch (event.getID()) {
            case 516: 
            case 517: {
                if (event.getSource() == this.m_mapTableModel) break;
                this.reinitialize();
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            this.m_mapTable.stopEditing();
            if (event.getSource() == this.m_mapNamesToolbar) {
                int nRowIndex = this.m_mapTable.getSelectedRow();
                if (nRowIndex == -1) {
                    return;
                }
                switch (event.getID()) {
                    case 0x10000000: {
                        String mapName = (String)this.m_mapTableModel.getValueAt(nRowIndex, this.m_mapTableModel.getActualColumnIndex(1));
                        boolean isUsing = this.checkMapIsUsing(mapName);
                        String msg = (isUsing ? VWResource.s_mapIsUsingStr : VWResource.s_mapIsNotUsingStr) + "  " + VWResource.s_continueQuestionStr;
                        if (VWMessageDialog.showConfirmDialog(this.m_authPropertyData.getMainContainer(), msg, VWResource.s_deleteMapStr, 3) != 1) break;
                        this.m_mapTableModel.deleteItem(nRowIndex);
                        break;
                    }
                    case 8192: {
                        this.performSubmapUsageAction();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow > this.m_mapTable.getRowCount() - 1) {
                    nRow = this.m_mapTable.getRowCount() - 1;
                }
                if (nRow == this.m_mapTable.getSelectedRow()) {
                    this.m_mapTable.clearSelection();
                }
                this.m_mapTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
            case 0: {
                if (event.getColumn() != -1 || this.m_mapTable.getSelectedRow() != event.getLastRow()) break;
                this.updateToolbarButtonStates();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (!event.getValueIsAdjusting()) {
                this.updateToolbarButtonStates();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableActionPerformed(VWTableActionEvent event) {
        switch (event.getID()) {
            case 100: {
                if (this.m_mapTable == null) break;
                this.m_mapTable.stopEditing();
            }
        }
    }

    protected void init(VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.createControls();
            this.reinitialize();
            this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
            this.m_authPropertyData.getTableActionEventNotifier().addTableActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void reinitialize() {
        try {
            if (this.m_mapTableModel != null) {
                this.m_mapTableModel.reinitialize();
            }
            this.m_mapTable.clearSelection();
            this.m_mapTable.setRowSelectionInterval(0, 0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void stopEditing() {
        if (this.m_mapTable != null) {
            this.m_mapTable.stopEditing();
        }
    }

    protected void releaseReferences() {
        this.m_authPropertyData.getMapChangeEventNotifier().removeMapChangedListener(this);
        this.m_authPropertyData.getTableActionEventNotifier().removeTableActionListener(this);
        if (this.m_mapNamesToolbar != null) {
            this.m_mapNamesToolbar.removeToolbarBorderActionNotifier(this);
            this.m_mapNamesToolbar = null;
        }
        if (this.m_mapTable != null) {
            this.m_mapTable.getSelectionModel().removeListSelectionListener(this);
            this.m_mapTable = null;
        }
        if (this.m_mapTableModel != null) {
            this.m_mapTableModel.removeTableModelListener(this);
            this.m_mapTableModel = null;
        }
        this.m_authPropertyData = null;
        this.removeAll();
    }

    private void createControls() {
        try {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
            this.m_mapNamesToolbar = new VWToolbarBorder(VWResource.s_maps, 0x10002000);
            this.m_mapNamesToolbar.addToolbarBorderActionNotifier(this);
            JPanel clientPanel = this.m_mapNamesToolbar.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_mapTableModel = new VWMapTableModel(this.m_authPropertyData, this);
            this.m_mapTableModel.addTableModelListener(this);
            this.m_mapTable = new VWTable(this.m_mapTableModel);
            this.m_mapTable.setName("m_mapTable_VWMapPanel");
            this.m_mapTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_mapTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            this.m_mapTable.setRowSelectionAllowed(true);
            this.m_mapTable.getSelectionModel().addListSelectionListener(this);
            this.m_mapTable.getSelectionModel().setSelectionMode(0);
            clientPanel.add((Component)new JScrollPane(this.m_mapTable), "Center");
            TableColumn tcElement = null;
            if (this.m_authPropertyData.getShowInheritedProperties() && (tcElement = this.m_mapTable.getColumnModel().getColumn(this.m_mapTableModel.getActualColumnIndex(0))) != null) {
                tcElement.setMaxWidth(20);
                tcElement.setMinWidth(20);
            }
            if ((tcElement = this.m_mapTable.getColumnModel().getColumn(this.m_mapTableModel.getActualColumnIndex(1))) != null) {
                tcElement.setCellRenderer(new VWMapTableCellRenderer());
            }
            if ((tcElement = this.m_mapTable.getColumnModel().getColumn(this.m_mapTableModel.getActualColumnIndex(2))) != null) {
                tcElement.setCellRenderer(new VWFieldsCellRenderer());
            }
            this.add((Component)this.m_mapNamesToolbar, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateToolbarButtonStates() {
        try {
            int nRowCount;
            this.m_mapNamesToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_mapNamesToolbar.getClientPanel(), 2, Integer.MAX_VALUE));
            int nRowIndex = this.m_mapTable.getSelectedRow();
            if (this.m_mapTableModel != null && nRowIndex != -1 && nRowIndex != (nRowCount = this.m_mapTableModel.getRowCount()) - 1) {
                int nButtons = 8192;
                if (this.m_mapTableModel.canDeleteRow(nRowIndex)) {
                    nButtons |= 0x10000000;
                }
                this.m_mapNamesToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_mapNamesToolbar.getClientPanel(), 1, nButtons));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performSubmapUsageAction() {
        try {
            int nRowIndex = this.m_mapTable.getSelectedRow();
            String mapName = (String)this.m_mapTableModel.getValueAt(nRowIndex, this.m_mapTableModel.getActualColumnIndex(1));
            if (VWStringUtils.compare(mapName, "Workflow") == 0) {
                mapName = VWResource.s_mainMapLabel.toString(mapName);
            }
            VWSubmapUsageDialog mapUsageDialog = new VWSubmapUsageDialog(this.m_authPropertyData.getMainContainer(), this.m_authPropertyData, mapName);
            mapUsageDialog.init();
            mapUsageDialog.setVisible(true);
            Object var3_4 = null;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean checkMapIsUsing(String checkMapName) {
        try {
            VWMapDefinition[] mapDefs;
            if (this.m_authPropertyData == null) {
                return false;
            }
            VWWorkflowDefinition workflowDef = this.m_authPropertyData.getWorkflowDefinition();
            if (workflowDef != null && (mapDefs = workflowDef.getMaps()) != null) {
                for (int i = 0; i < mapDefs.length; ++i) {
                    VWMapNode[] mapNodes = mapDefs[i].getSteps();
                    if (mapNodes == null) continue;
                    block6: for (int j = 0; j < mapNodes.length; ++j) {
                        switch (VWStepUtils.getStepType(mapNodes[j])) {
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: {
                                String[] callerMapNames = VWStepUtils.getCalledMapNames(mapNodes[j]);
                                if (callerMapNames == null || callerMapNames.length <= 0) continue block6;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }
}

